$(function(){
    var $body = $('body');
    
    $('.to-labelauty-icon').labelauty({ label: false });
    
    $('a[href^="#"]').on('click',function (e) {
        e.preventDefault();

        var target = this.hash;
        var $target = $(target);

        $('html, body').stop().animate({
                'scrollTop': $target.offset().top
        }, 900, 'swing');
    });

    $body.on('click', '#submit-inq', function(e){
        e.preventDefault();

        $('#inq-progress').slideDown();
        $('#submit-inq').slideUp();

        var $form = $('#inq-form');
        var data = $form.serialize();
        var url = $form.attr('action');

        $.ajax({
            url: url,
            type: 'POST',
            data: data,
            dataType: 'json',
            success: function(response) {
                $('#alertdiv').html('');
                $('#alertdiv').css('display', 'none');

                var messages = response.message;
                if ( response == 'empty' || !response.isSuccess ) {
                    if ( typeof fastjobsTagging !== 'undefined' ) {
                      fastjobsTagging.tagEvent({name: 'employer_request_account_failed'});
                    }

                    $('#alertdiv').html('<h5><span class="glyphicon glyphicon-warning-sign"></span>&nbsp; Please correct the following errors:</h5>');
                    $.each(messages, function(i) {
                        if ( i != 0 ) {
                            $('#alertdiv').append( '<br />' );
                        }
                        $('#alertdiv').append( "* &nbsp; " + messages[i].trim() );
                    });
                    $('#alertdiv').removeClass().addClass('alert alert-danger');
                    $('#alertdiv').css('display', 'block');
                } else {
                    if ( typeof fastjobsTagging !== 'undefined' ) {
                      fastjobsTagging.tagEvent({name: 'employer_request_account_success'});
                    }

                    $form.trigger('reset');
                    $('.company-size-area').show();
                    $('#verifyCode-image').trigger('click');
                    $('#alertdiv').removeClass().addClass('alert alert-success');
                    $('#alertdiv').html( '' + messages[0].trim() ).css('display', 'block');
                }

                $('html, body').stop().animate({
                    'scrollTop': $('#signup').offset().top
                }, 'fast', 'swing');
            },
            complete: function() {
                $('#inq-progress').slideUp();
                $('#submit-inq').slideDown();
            }
        });
        
        return false;
    });

    $body.on('click', '#refresh-code', function(e){
        e.preventDefault();
        $('#verifyCode-image').trigger('click');
    });
    
    $body.on('click', '#isstartup', function(e){
        if ( $(this).is(':checked') ) {
            $('#companysize option').removeAttr('selected');
            $('.company-size-area').hide();
        }
        else {
            $('.company-size-area').show();
        }
    });
});

