<!--HEADER-SECTION-->
<?php $this->load->view('header_front');
//code for to get the page content	
foreach ($aboutconent as $val_content) {
    $title = $val_content->title;
    $body_content = $val_content->body;
}
//error_reporting(0);
?>
<!--HEADER-SECTION-->

<!--CONTENT-AREA-->
<div class="content-section">

    <!--WELCOME-JNJ-->
    <div class="section-welcome">

        <div class="container">
            <div class="nav-welcome">
                <ol class="breadcrumb">
                    <li><a href="<?php echo base_url(); ?>">Home</a></li>
                    <li><a href="<?php echo base_url(); ?>front_end/salary_calculator">Salary Calculator</a></li>
                </ol>
                <a class="menubtn" href="#"><i class="fa fa-bars"></i></a>
            </div>

            <div class="gradient">
                <div class="row">

                    <div class="col-md-3">
                        <div class="main-heading">
                            <h1>Salary </br>Calculator</h1>
                        </div>
                        <div class="aboutus-image">
                            <img src="<?php echo base_url(); ?>assets_front/images/chair.png" alt="image">
                        </div>
                    </div>

                    <div class="col-md-9">

                            <p style="font-size:18px; padding-left: 20px;">Calculate your salary, find out the amount you will be taking
                                home, and how much tax you have to pay.</p>
<?php
class Tax_Code_Calculator {
	
	public $tax_code;
	public $tax_code_letter;

	public function __construct( $tax_code ) {
	
	define("TAX_CODE_D0","D0");
	define("TAX_CODE_D1","D1");
	define("TAX_CODE_BR","BR");
    define("TAX_CODE_NT","NT");
	define("TAX_CODE_K","K");
		$this->tax_code = $tax_code;
		$this->get_personal_allowance_from_code();
	}

	public function tax_code_calculator() {
		// Find a valid tax code letter from the input field
		// Not required for most letters, but needed in particular for K
		// preg_match('/([KDLYTP]+)/i', $this->tax_code_is, $taxCodeLetter); (Don't need to find all valid tax code letters right now)

		preg_match( '/([K]+)/i', $this->tax_code, $tax_code_letter );

		// Now we've got the letter we can strip it from the string to perform calculations
		$this->personal_allowance = preg_replace( '/\D/', '', $this->tax_code );
		$this->special_tax_codes = array( 
			self::TAX_CODE_D0,
			self::TAX_CODE_D1,
			self::TAX_CODE_BR,
			self::TAX_CODE_NT, 
			);

		if ( ! empty( $tax_code_letter ) ) {
			$this->tax_code_letter = $tax_code_letter[ 0 ];
		}
	}

	/*
	 * Finds the letter in the tax code for calculating the personal allowance
	 * If the code is K, the amount is added to the total taxable
	 * If not, perform the calculation to work out the personal allowance
	 *
	 * @return int Annual personal allowance based on tax code          
	 */
	public function get_personal_allowance_from_code() {
		$this->tax_code_calculator();

		if ( ! empty( $this->personal_allowance ) ) {
			if ( isset( $this->tax_code_letter ) && self::TAX_CODE_K === $this->tax_code_letter[ 0 ] ) {
				$add_to_total_taxable = $this->personal_allowance * 10;

				return $add_to_total_taxable;
			} elseif ( in_array( $this->tax_code, $this->special_tax_codes ) ) {
				return 0;
			} else {
				$division = $this->personal_allowance / 500;
				$quotient = floor( $division );
				$fraction = $division - $quotient;
				$remainder = $fraction *  500;
				$personal_allowance = $quotient * 500 * 10 + (($remainder * 10) + 9);
				
				return $personal_allowance;
			}
		}
	}
}
//code for class national inurnace
class National_Insurance_Calculator {

/*	const BAND_START = 'start';
	
	const BAND_END = 'end';
	const BAND_RATE = 'rate';
	const THRESHOLD_PRIMARY = 'primary';
	const THRESHOLD_UPPER = 'upper';
	const NUMBER_OF_WEEKS = 52;
	const BAND_END_MAX = 9999999999999999999;*/
    
	public $weekly_income;
	public $tax_year;
	public $ni_bands;

	public function __construct($weekly_income, $tax_year, $ni_bands) {
	define("BAND_START","start");
	define("BAND_END","end");
	define("BAND_RATE","rate");
	define("THRESHOLD_PRIMARY","primary");
	define("THRESHOLD_UPPER","upper");
	define("NUMBER_OF_WEEKS",52);
	define("BAND_END_MAX",9999999999999999999);
		$this->weekly_income = $weekly_income;
		$this->tax_year = $tax_year;
		$this->get_ni_bands = $ni_bands;
		$this->ni_bands = $this->get_ni_bands[ $this->tax_year ];
	}

	/*
	 * Loops through the national insurance bands to check if the income is
	 * within the band to find the total weekly contribution.
	 *
	 * @return float The lowest value of the two checked 			          
	 */
	public function get_ni_contributions() {
		$band_deductions = 0;
		$values = array();
		foreach ( $this->ni_bands as $key => $band ) {

			if ( null === $band[ self::BAND_END ] ) {
				$band[ self::BAND_END ] = self::BAND_END_MAX;
			}

			if ( $this->weekly_income > $band[ self::BAND_START ] ) {
				if ( $band[ self::BAND_END ] && $band[ self::BAND_END ] > 0 ) {
					$deductable_amount = min( $this->weekly_income, $band[ self::BAND_END ] ) - $band[ self::BAND_START ];
				} else {
					$deductable_amount = $this->weekly_income - $band[ self::BAND_START ];
				}

			} elseif ( $this->weekly_income < $band[ self::BAND_START ] ) {
				$deductable_amount = 0;
			}
				$band_deductions = ($deductable_amount / 100) * $band[ self::BAND_RATE ];
				$values[ $key ] = $band_deductions;	
		}

		$total_contribution = ( $values[ self::THRESHOLD_PRIMARY ] + $values[ self::THRESHOLD_UPPER ] ) * self::NUMBER_OF_WEEKS;

		return $total_contribution;
	}
}

class Tax_Calculator {

	


	/*
	 * Sets the default values we need when the class is instantiated.
	 *
	 * @param array $persona User submitted inputs
	 * @param array $income_tax_rates Raw data for all tax years           
	 */
	public function __construct( $persona ) {
	define("TAX_YEAR","year");
	if (!defined('MONTH'))
	{
	define("MONTH","month");
	}
	define("INCOME","income");
	define("OTHER_ALLOWANCE","other_allowance");
	define("TAX_CODE","tax_code");
	define("AGE","age");
	define("PENSION","pension");
	define("PENSION_EVERY","pension_every");
	define("VOUCHERS","vouchers");
	define("CHILDCARE_PRE2011","childcare_pre2011");
	define("BLIND","blind");
	define("ALLOWANCE_BLIND","blind_persons");
	define("EXCLUDE_NI","exclude_ni");
	define("STUDENT_LOAN","student_loan");
	define("MARRIED","married");
	define("RATES","rates");
	define("ALLOWANCES","allowances");
	define("ALLOWANCE_PERSONAL","personal");
	define("ALLOWANCE_PERSONAL_65_74","personal_for_people_aged_65_74");
	define("ALLOWANCE_PERSONAL_75_AND_OVER","personal_for_people_aged_75_and_over");
	define("AGE_65_74","65_74");
	define("AGE_OVER_75","over_75");
	define("income_limit_for_age_related","income_limit_for_personal");
	define("INCOME_LIMIT_FOR_AGE_RELATED","income_limit_for_age_related");
	define("ALLOWANCE_MARRIED_COUPLES_OVER_75","married_couples_over_75");
	define("TAX_CODE_K","K");
	define("SAVINGS","savings");
	define("TAX_CODE_BR","BR");
	define("TAX_CODE_D0","D0");
	define("TAX_CODE_D1","D1");
	define("TAX_CODE_NT","NT");
	define("BAND_START","start");
	define("BAND_END","end");
	define("BAND_RATE","rate");
	define("BAND_BASIC","basic");
	define("BAND_HIGHER","higher");
	define("BAND_ADDITIONAL","additional");
	define("AMOUNT","amount");
	define("PERCENTAGE_AMOUNT","percentage_amount");
	define("ON","on");
	define("YEAR2013_14","year2013_14");
	define("YEAR2014_15","year2014_15");
	define("YEAR2015_16","year2015_16");
		//include 'data/income-tax-rates.php';
		//include 'data/national-insurance-rates.php';
		//include 'data/student-loan-rates.php';
		//include 'data/childcare-voucher-rates.php';
//code for income-tax-rates
$income_tax_rates = array(
    'year2009_10' => array(
        'allowances' => array(
            'personal' => 6475,
            'income_limit_for_personal' => null,
            'personal_for_people_aged_65_74' => 9490,
            'personal_for_people_aged_75_and_over' => 9640,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 6965,
            'income_limit_for_age_related' => 22900,
            'minimum_amount_of_married_couples' => 2670,
            'blind_persons' => 1890,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2440
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 37400
                ),
            'higher' => array(
                'rate' => 40,
                'start' => 37400,
                'end' => null,
                ),
            'additional' => null,
        )
    ),
    'year2010_11' => array(
        'allowances' => array(
            'personal' => 6475,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 9490,
            'personal_for_people_aged_75_and_over' => 9640,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 6965,
            'income_limit_for_age_related' => 22900,
            'minimum_amount_of_married_couples' => 2670,
            'blind_persons' => 1890,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2440,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 37400,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 37400,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 50,
                'start' => 150000,
                'end' => null,
            )           
        )
    ),
    'year2011_12' => array(
        'allowances' => array(
            'personal' => 7475,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 9940,
            'personal_for_people_aged_75_and_over' => 10090,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 7295,
            'income_limit_for_age_related' => 24000,
            'minimum_amount_of_married_couples' => 2800,
            'blind_persons' => 1980,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2560,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 35000,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 35000,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 50,
                'start' => 150000,
                'end' => null,
            )          
        )
    ),
    'year2012_13' => array(
        'allowances' => array(
            'personal' => 8105,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 10500,
            'personal_for_people_aged_75_and_over' => 10660,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 7705,
            'income_limit_for_age_related' => 25400,
            'minimum_amount_of_married_couples' => 2960,
            'blind_persons' => 2100,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2710,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 34370,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 34370,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 50,
                'start' => 150000,
                'end' => null,
            )          
        )
    ),
    'year2013_14' => array(
        'allowances' => array(
            'personal' => 9440,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 10500,
            'personal_for_people_aged_75_and_over' => 10660,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 7915,
            'income_limit_for_age_related' => 26100,
            'minimum_amount_of_married_couples' => 3040,
            'blind_persons' => 2160,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2790,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 32010,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 32010,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 45,
                'start' => 150000,
                'end' => null,
            )           
        )
    ),
    'year2014_15' => array(
        'allowances' => array(
            'personal' => 10000,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 10500,
            'personal_for_people_aged_75_and_over' => 10660,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 8165,
            'income_limit_for_age_related' => 27000,
            'minimum_amount_of_married_couples' => 3140,
            'blind_persons' => 2230,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2880,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 31865,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 31865,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 45,
                'start' => 150000,
                'end' => null,
            )
        )           
    )
);		
//code for national-insurance-rates
$national_insurance_rates = array(
	'year2009_10' => array(
		'primary' => array(
			'rate' => 11,
			'start' => 110,
			'end' => 844,
			),
		'upper' => array(
			'rate' => 1,
			'start' => 844,
			'end' => null,
			)
		),
	'year2010_11' => array(
		'primary' => array(
			'rate' => 11,
			'start' => 110,
			'end' => 844,
			),
		'upper' => array(
			'rate' => 1,
			'start' => 844,
			'end' => null,
			)
		),
	'year2011_12' => array(
		'primary' => array(
			'rate' => 12,
			'start' => 139,
			'end' => 817,
			),
		'upper' => array(
			'rate' => 2,
			'start' => 817,
			'end' => null,
			)
		),
	'year2012_13' => array(
		'primary' => array(
			'rate' => 12,
			'start' => 146,
			'end' => 817,
			),
		'upper' => array(
			'rate' => 2,
			'start' => 817,
			'end' => null,
			)
		),
	'year2013_14' => array(
		'primary' => array(
			'rate' => 12,
			'start' => 149,
			'end' => 797,
			),
		'upper' => array(
			'rate' => 2,
			'start' => 797,
			'end' => null,
			)
		),
	'year2014_15' => array(
		'primary' => array(
			'rate' => 12,
			'start' => 153,
			'end' => 805,
			),
		'upper' => array(
			'rate' => 2,
			'start' => 805,
			'end' => null,
			)
		)
	);
		
//code for student-loan-rates
$student_loan_rates = array(
	'year2009_10' => array(
		'rate' => 9,
		'start' => 15000,
		),
	'year2010_11' => array(
		'rate' => 9,
		'start' => 15000,
		),
	'year2011_12' => array(
		'rate' => 9,
		'start' => 15000,
		),
	'year2012_13' => array(
		'rate' => 9,
		'start' => 15795,
		),
	'year2013_14' => array(
		'rate' => 9,
		'start' => 16365,
		),
	'year2014_15' => array(
		'rate' => 9,
		'start' => 16910,
		)
		,	'year2015_16' => array(
		'rate' => 9,
		'start' => 17010,
		),
	);


//code for childcare-voucher-rates
$annual_childcare_voucher_rates = array(
	'basic' => 2915,
	'higher' => 1484,
	'additional' => 1166,
);


		// Set the persona and values
		$this->persona = $persona;
		$this->year = $this->persona[self::TAX_YEAR];
		$this->income = $this->persona[self::INCOME];
		$this->other = $this->persona[self::OTHER_ALLOWANCE];
		$this->tax_code = $this->persona[self::TAX_CODE];
		$this->age = $this->persona[self::AGE];
		$this->pension = $this->persona[self::PENSION];
		$this->pension_every = $this->persona[self::PENSION_EVERY];
		$this->vouchers = $this->persona[self::VOUCHERS];
		$this->childcare_pre2011 = $this->persona[self::CHILDCARE_PRE2011];
		$this->blind = $this->persona[self::BLIND];
		$this->exclude_ni = $this->persona[self::EXCLUDE_NI];
		$this->student_loan = $this->persona[ self::STUDENT_LOAN];
		$this->married = $this->persona[self::MARRIED];

		// Set tax rates
		$this->rates = $income_tax_rates;
		$this->ni_rates = $national_insurance_rates;	
		$this->bands = $this->rates[$this->year][self::RATES];
		$this->allowances = $this->rates[$this->year][ self::ALLOWANCES];
		$this->student_rates = $student_loan_rates[ $this->year];
		$this->voucher_rates = $annual_childcare_voucher_rates;
	}

	/*
	 * Gets the personal allowance figure based on the users age.
	 *
	 * @return int The personal allowance for chosen tax year, by age	 	          
	 */
	public function get_personal_allowance() {
		if ( self::AGE_65_74 === $this->age ) {
			return $this->allowances[ self::ALLOWANCE_PERSONAL_65_74];
		} elseif ( self::AGE_OVER_75 === $this->age ) {
			return $this->allowances[self::ALLOWANCE_PERSONAL_75_AND_OVER];
		} else {
			return $this->allowances[self::ALLOWANCE_PERSONAL];
		}	
	}

	/*
	 * Find and set the income allowance limit
	 *
	 * @return int The income limit for chosen tax year, by age           
	 */
	public function get_income_allowance_limit() {
		if ( self::AGE_65_74 === $this->age || self::AGE_OVER_75 === $this->age) {
			return $this->allowances[self::INCOME_LIMIT_FOR_AGE_RELATED];
		} else {
			return $this->allowances[self::INCOME_LIMIT_FOR_PERSONAL];
		}
	}

	/*
	 * Calculate the tax free amount that user is entitled to
	 *
	 * @return int The tax free allowance for chosen tax year           
	 */
	public function get_tax_free_allowance() {
		$personal_allowance = $this->get_personal_allowance();
		$income_allowance_limit = $this->get_income_allowance_limit();

		if ( $this->income > $income_allowance_limit ) {
			$deduct_from_allowance = ( $this->income - $income_allowance_limit ) / 2;
			$personal_allowance = $personal_allowance - $deduct_from_allowance;

			if ( self::AGE_65_74 === $this->age || self::AGE_OVER_75 === $this->age ) {
				if ( $personal_allowance <= $this->allowances[ self::ALLOWANCE_PERSONAL] ) {
					$personal_allowance = $this->allowances[ self::ALLOWANCE_PERSONAL];
					$income_allowance_limit = $this->allowances[ self::INCOME_LIMIT_FOR_PERSONAL];

					if ( $this->income > $income_allowance_limit) {
						$deduct_from_allowance = ( $this->income - $income_allowance_limit) / 2;
						$personal_allowance = $personal_allowance - $deduct_from_allowance;
					}
				}
			}
		}

		// Note: this isn't working when using a K tax code. 
		// TODO: Add/Deduct $this->other to/from total_taxable_amount instead
		if ( isset( $this->other ) ) {
				$personal_allowance += $this->other;
			}

			if ( $personal_allowance < 0 ) {
				$personal_allowance = 0;
			} 

		return $personal_allowance;
	}

	/*
	 * Finds the blind allowance for the chosen tax year
	 *
	 * @return int Blind persons allowance          
	 */
	public function get_blind_persons_allowance() {
		return $this->allowances[self::ALLOWANCE_BLIND];
	}

	/*
	 * Determines whether user is eligible for married couples allowance
	 *
	 * @return int Married couples allowance (10% of the allowance)          
	 */
	public function get_married_couples_allowance() {
		return ( $this->allowances[self::ALLOWANCE_MARRIED_COUPLES_OVER_75] / 100 ) * 10;
		}

	/*
	 * Determines the personal allowance based on entered tax code
	 * Replaces tax free allowance with calculated amount if the code isn't K
	 * Adds the calculated amount to the total taxable amount if it is K
	 *
	 * @return int Personal allowance by tax code          
	 */
	public function get_tax_code_personal_allowance() {
		$tax_code_calculator = new Tax_Code_Calculator($this->tax_code);

		$this->tax_code_personal_allowance = $tax_code_calculator->get_personal_allowance_from_code();
		$this->tax_code_letter = $tax_code_calculator->tax_code_letter;

		if ( is_numeric( $this->tax_code_personal_allowance) && self::TAX_CODE_K === $this->tax_code_letter) {
			$this->total_taxable_amount = $this->show_gross_income + $this->tax_code_personal_allowance;
			$this->show_tax_free_allowance = 0;
		} elseif ( is_numeric( $this->tax_code_personal_allowance ) && self::TAX_CODE_K !== $this->tax_code_letter ) {
			$this->show_tax_free_allowance = $this->tax_code_personal_allowance;
			$this->total_taxable_amount = $this->show_gross_income - $this->show_tax_free_allowance;
		} 
	}

	/*
	 * Checks if the tax code is one of the special codes to work out
	 * Compares the total taxable amount against the tax bands for chosen year
	 * and works out the value of tax for each banding
	 *
	 * @return int Personal allowance by tax code          
	 */
	public function calculate_tax_bands() {
		unset( $this->bands[ self::SAVINGS ] );

		if ( isset( $this->tax_code ) ) {
			$output = array();
			switch( $this->tax_code ) {
				case self::TAX_CODE_BR:
					// Basic Rate percentage
					$this->show_tax_free_allowance = 0;
					$this->total_taxable_amount = $this->show_gross_income;
					$band_percentage = $this->bands[ self::BAND_BASIC ][ self::BAND_RATE];
					$percentage_amount = ( $this->total_taxable_amount / 100 ) * $band_percentage;
					$output[ self::BAND_BASIC] = round( $percentage_amount );
					$output[ self::BAND_HIGHER] = 0;
					$output[ self::BAND_ADDITIONAL] = 0;

					return $output;
				case self::TAX_CODE_D0:
					// Higher Band percentage
					$this->show_tax_free_allowance = 0;
					$this->total_taxable_amount = $this->show_gross_income;
					$band_percentage = $this->bands[ self::BAND_HIGHER ][self::BAND_RATE];
					$percentage_amount = ( $this->total_taxable_amount / 100 ) * $band_percentage;
					$output[ self::BAND_BASIC] = 0;
					$output[ self::BAND_HIGHER] = round( $percentage_amount);
					$output[ self::BAND_ADDITIONAL] = 0;

					return $output;
				case self::TAX_CODE_D1:
					// Additional Band percentage
					$this->show_tax_free_allowance = 0;
					$this->total_taxable_amount = $this->show_gross_income;
					$band_percentage = $this->bands[ self::BAND_ADDITIONAL ][ self::BAND_RATE];
					$percentage_amount = ( $this->total_taxable_amount / 100 ) * $band_percentage;
					$output[self::BAND_BASIC] = 0;
					$output[self::BAND_HIGHER] = 0;
					$output[self::BAND_ADDITIONAL] = round( $percentage_amount);
					$this->show_tax_free_allowance = 0;

					return $output;
				case self::TAX_CODE_NT:
					// No Tax

					return 0;
			}
		}

		$values = array();
		foreach ( $this->bands as $key => $band ) {
			if ( null !== $band[ self::BAND_END ] || $band[ self::BAND_END ] > 0 ) {
				$band[ self::AMOUNT ] = min( $this->total_taxable_amount, $band[ self::BAND_END ] ) - $band[ self::BAND_START ];
			} else {
				$band[ self::AMOUNT ] = $this->total_taxable_amount - $band[ self::BAND_START ];
			}

			$band[ self::PERCENTAGE_AMOUNT ] = ( $band[ self::AMOUNT ] / 100 ) * $band[ self::BAND_RATE ];
			$total_deduction = $band[ self::PERCENTAGE_AMOUNT ];
				
			if ( $total_deduction < 0 ) {
				$total_deduction = 0;
			}

			$values[ $key ] = $total_deduction;		
		}

		return $values;
	}

	/*
	 * Takes total weekly income less deductions and works out the national
	 * insurance contributions for the primary and upper bandings.
	 *
	 * @return int Annual national insurance contributions 
	 */
	public function get_national_insurance_contribution() {
		$annual_vouchers = $this->get_childcare_voucher_amount();
		$national_insurance_calculator = new National_Insurance_Calculator( 
										( $this->income - $annual_vouchers ) / 52, $this->year, $this->ni_rates );

		return $national_insurance_calculator->get_ni_contributions();
	}

	/*
	 * Takes gross income less deductions and works out whether the income
	 * is over the start amount before calculating the repayment amount
	 * Student loans are also rounded down to the nearest pound.
	 *
	 * @return int Annual student loan repayment amount    
	 */
	public function get_student_loan_repayment() {
		if ( $this->income >= $this->student_rates[ self::BAND_START ] ) {
			$deductable_amount = $this->income - $this->student_rates[ self::BAND_START ];

			if ( isset( $this->vouchers ) ) {
				$deductable_amount -= $this->vouchers;
			}

			$deduction = ( $deductable_amount / 100 ) * $this->student_rates[ self::BAND_RATE ];

			return floor( $deduction );
		}
	}

	/*
	 * Checks the pension amount for a % symbol and if found calculates the
	 * percentage based on the annual income.  If there is no %, the entered
	 * amount will be used instead.
	 *
	 * @return int Annual pension amount    
	 */
	public function get_employers_pension_amount() {
		preg_match( '/[%]/', $this->pension, $pension_percentage );

		if ( ! empty( $pension_percentage ) && '%' === $pension_percentage[0] ) {
			$pension_percentage_amount = preg_replace( '/\D/', '', $this->pension );

			if ( self::MONTH === $this->pension_every ) {
				$monthly_income = $this->income / 12;

				$pension_amount = ( $monthly_income / 100 ) * $pension_percentage_amount;
				$annual_amount = $pension_amount * 12;

				return $annual_amount;
			} else {
				$annual_amount = ( $this->income / 100 ) * $pension_percentage_amount;

				return $annual_amount;
			}
		} else {
			if ( self::MONTH === $this->pension_every ) {
				
				$pension_amount = $this->pension;
				$annual_amount = $pension_amount * 12;

				return $annual_amount;
			} else {
				$annual_amount = $this->pension;

				return $annual_amount;
			}
		}
	}

	/*
	 * Checks tax banding to see whether income is in a higher or additional band
	 * If so, calculates the pension relief amount by multiplying the pension
	 * amount by the tax band rate.
	 *
	 * @return int Annual HMRC pension relief    
	 */
	public function get_hmrc_employers_pension_amount( $pension_amount ) {
		$tax_bands = $this->calculate_tax_bands();

		if ( $tax_bands[ self::BAND_HIGHER ] > 0 && 0 === $tax_bands[ self::BAND_ADDITIONAL ] ) {
			return ($pension_amount / 100) * $this->bands[ self::BAND_HIGHER ][ self::BAND_RATE ];
		} elseif ( $tax_bands[ self::BAND_ADDITIONAL ] > 0 ) {
			return ($pension_amount / 100) * $this->bands[ self::BAND_ADDITIONAL ][ self::BAND_RATE ];
		} else {
			return ($pension_amount / 100) * $this->bands[ self::BAND_BASIC ][ self::BAND_RATE ];
		}
	}

	/*
	 * Checks whether the childcare voucher amount is within the limits allowed and 
	 * if too high, returns the maximum allowed amount.  If the amount is in a higher
	 * or additional tax band, a lower amount will be used.
	 *
	 * @return integer Annual childcare voucher amount   
	 */
	public function get_childcare_voucher_amount() {
		$income = $this->income;
		$bands = $this->bands;
		$vouchers = $this->vouchers;
		$rates = $this->voucher_rates;
		$pre2011 = $this->childcare_pre2011;

		if ( $vouchers > $rates[ self::BAND_BASIC ] ) {
			$vouchers = $rates[ self::BAND_BASIC ];
		}

		if ( $income >= $bands[ self::BAND_HIGHER ][ self::BAND_START ] && $vouchers > $rates[ self::BAND_HIGHER ] && self::ON !== $pre2011 ) {
			$vouchers = $rates[ self::BAND_HIGHER ];
		} 

		if ( $income >= $bands[ self::BAND_ADDITIONAL ][ self::BAND_START ] && $vouchers > $rates[ self::BAND_ADDITIONAL ] && self::ON !== $pre2011 ) {
			if ( self::YEAR2013_14 === $this->year || self::YEAR2014_15 === $this->year ) {
				$rates[ self::BAND_ADDITIONAL ] = 1320;

				$vouchers = $rates[ self::BAND_ADDITIONAL ];
			}

			$vouchers = $rates[ self::BAND_ADDITIONAL ];
		} 

		return $vouchers;
	}

	/*
	 * Calculate the taxes for user and pull all figures together
	 *
	 * @return mixed Return everything we need to populate the tax calculation table         
	 */
	public function calculate_taxes() {
		$this->show_gross_income = $this->income;
		$this->show_tax_free_allowance = $this->get_tax_free_allowance();
		$this->total_taxable_amount = $this->show_gross_income - $this->show_tax_free_allowance;
		$this->show_total_deduction = 0;

		if ( self::ON === $this->married && self::AGE_OVER_75 === $this->age ) {
			$this->show_married_allowance = $this->get_married_couples_allowance();
		}

		if ( self::ON === $this->blind ) {
			$this->show_blind_allowance = $this->get_blind_persons_allowance();
			$this->show_tax_free_allowance += $this->show_blind_allowance;
			$this->total_taxable_amount -= $this->show_blind_allowance;
		}

		if ( isset( $this->tax_code ) ) {
			$this->get_tax_code_personal_allowance();
		}

		if ( isset( $this->pension ) ) {
			$this->show_employer_pension = $this->get_employers_pension_amount();
			$this->show_pension_hmrc = $this->get_hmrc_employers_pension_amount( $this->show_employer_pension );
			$this->total_taxable_amount -= $this->show_employer_pension;
			$this->show_total_deduction += $this->show_employer_pension;
		}

		if ( isset( $this->vouchers ) ) {
			$this->show_childcare_vouchers = $this->get_childcare_voucher_amount();
			$this->total_taxable_amount -= $this->show_childcare_vouchers;
			$this->show_total_deduction += $this->show_childcare_vouchers;
		}

		if ( self::ON === $this->student_loan ) {
			$this->show_student_loan_amount = $this->get_student_loan_repayment();
			$this->show_total_deduction += $this->show_student_loan_amount;
		}

		if ( self::ON === $this->exclude_ni || self::AGE_OVER_75 === $this->age || self::AGE_65_74 === $this->age ) {
			$this->show_ni_contribution = 0;
		} else {
			$this->show_ni_contribution = $this->get_national_insurance_contribution();
			$this->show_total_deduction += $this->show_ni_contribution;
		}

		if ( $this->show_gross_income <= $this->show_tax_free_allowance ) {
			$this->total_taxable_amount = 0;
			$this->total_tax_due = 0;
		} else {
			$this->deduction = $this->calculate_tax_bands();
			$this->total_tax_due = $this->deduction[ self::BAND_BASIC ] + $this->deduction[ self::BAND_HIGHER ] + $this->deduction[ self::BAND_ADDITIONAL ];
			$this->show_total_deduction += $this->total_tax_due;
		} 

		$this->show_net_income = $this->show_gross_income - $this->show_total_deduction;
	}
}

//income-tax-rates code
$income_tax_rates = array(
    'year2009_10' => array(
        'allowances' => array(
            'personal' => 6475,
            'income_limit_for_personal' => null,
            'personal_for_people_aged_65_74' => 9490,
            'personal_for_people_aged_75_and_over' => 9640,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 6965,
            'income_limit_for_age_related' => 22900,
            'minimum_amount_of_married_couples' => 2670,
            'blind_persons' => 1890,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2440
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 37400
                ),
            'higher' => array(
                'rate' => 40,
                'start' => 37400,
                'end' => null,
                ),
            'additional' => null,
        )
    ),
    'year2010_11' => array(
        'allowances' => array(
            'personal' => 6475,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 9490,
            'personal_for_people_aged_75_and_over' => 9640,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 6965,
            'income_limit_for_age_related' => 22900,
            'minimum_amount_of_married_couples' => 2670,
            'blind_persons' => 1890,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2440,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 37400,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 37400,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 50,
                'start' => 150000,
                'end' => null,
            )           
        )
    ),
    'year2011_12' => array(
        'allowances' => array(
            'personal' => 7475,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 9940,
            'personal_for_people_aged_75_and_over' => 10090,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 7295,
            'income_limit_for_age_related' => 24000,
            'minimum_amount_of_married_couples' => 2800,
            'blind_persons' => 1980,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2560,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 35000,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 35000,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 50,
                'start' => 150000,
                'end' => null,
            )          
        )
    ),
    'year2012_13' => array(
        'allowances' => array(
            'personal' => 8105,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 10500,
            'personal_for_people_aged_75_and_over' => 10660,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 7705,
            'income_limit_for_age_related' => 25400,
            'minimum_amount_of_married_couples' => 2960,
            'blind_persons' => 2100,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2710,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 34370,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 34370,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 50,
                'start' => 150000,
                'end' => null,
            )          
        )
    ),
    'year2013_14' => array(
        'allowances' => array(
            'personal' => 9440,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 10500,
            'personal_for_people_aged_75_and_over' => 10660,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 7915,
            'income_limit_for_age_related' => 26100,
            'minimum_amount_of_married_couples' => 3040,
            'blind_persons' => 2160,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2790,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 32010,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 32010,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 45,
                'start' => 150000,
                'end' => null,
            )           
        )
    ),
    'year2014_15' => array(
        'allowances' => array(
            'personal' => 10000,
            'income_limit_for_personal' => 100000,
            'personal_for_people_aged_65_74' => 10500,
            'personal_for_people_aged_75_and_over' => 10660,
            'married_couples_under_75' => null,
            'married_couples_over_75' => 8165,
            'income_limit_for_age_related' => 27000,
            'minimum_amount_of_married_couples' => 3140,
            'blind_persons' => 2230,
        ),
        'rates' => array(
            'savings' => array(
                'rate' => 10,
                'start' => 0,
                'end' => 2880,
            ),
            'basic' => array(
                'rate' => 20,
                'start' => 0,
                'end' => 31865,
            ),
            'higher' => array(
                'rate' => 40,
                'start' => 31865,
                'end' => 150000,
            ),
            'additional' => array(
                'rate' => 45,
                'start' => 150000,
                'end' => null,
            )
        )           
    )
);


//national-insurance-rates.php
$national_insurance_rates = array(
	'year2009_10' => array(
		'primary' => array(
			'rate' => 11,
			'start' => 110,
			'end' => 844,
			),
		'upper' => array(
			'rate' => 1,
			'start' => 844,
			'end' => null,
			)
		),
	'year2010_11' => array(
		'primary' => array(
			'rate' => 11,
			'start' => 110,
			'end' => 844,
			),
		'upper' => array(
			'rate' => 1,
			'start' => 844,
			'end' => null,
			)
		),
	'year2011_12' => array(
		'primary' => array(
			'rate' => 12,
			'start' => 139,
			'end' => 817,
			),
		'upper' => array(
			'rate' => 2,
			'start' => 817,
			'end' => null,
			)
		),
	'year2012_13' => array(
		'primary' => array(
			'rate' => 12,
			'start' => 146,
			'end' => 817,
			),
		'upper' => array(
			'rate' => 2,
			'start' => 817,
			'end' => null,
			)
		),
	'year2013_14' => array(
		'primary' => array(
			'rate' => 12,
			'start' => 149,
			'end' => 797,
			),
		'upper' => array(
			'rate' => 2,
			'start' => 797,
			'end' => null,
			)
		),
	'year2014_15' => array(
		'primary' => array(
			'rate' => 12,
			'start' => 153,
			'end' => 805,
			),
		'upper' => array(
			'rate' => 2,
			'start' => 805,
			'end' => null,
			)
		)
	);

define("DAY","day");
define("WEEK","week");
define("MONTH","month");
define("NUMBER_OF_MONTHS",12);
define("NUMBER_OF_WEEKS",52);
define("NUMBER_OF_WEEKS_ODD",53);
define("NUMBER_OF_DAYS",260);
/*define("DAY","day");
define("DAY","day");							
const DAY = 'day';
const WEEK = 'week';
const MONTH = 'month';
const NUMBER_OF_MONTHS = 12;
const NUMBER_OF_WEEKS = 52;
const NUMBER_OF_WEEKS_ODD = 53;
const NUMBER_OF_DAYS = 260;*/

/*
 * Determines whether a checkbox has been enabled and if so trims it.
 * If not, returns a null.
 *
 * @return string Returns "on" if the checkbox is enabled          
 */
function get_other_allowance( $name ) 
{
	return isset( $_POST[ $name ] ) ? trim( $_POST[ $name ] ) : null;
}

/*
 * Checks the income frequency and converts it to an annual amount.
 *
 * @return int Annual income          
 */
function get_annual_income( $frequency, $income ) 
{
	if ( DAY === $frequency ) {
		return $income * NUMBER_OF_DAYS;
	} elseif ( WEEK === $frequency ) {
		return $income * NUMBER_OF_WEEKS;
	} elseif ( MONTH === $frequency ) {
		return $income * NUMBER_OF_MONTHS;
	} else {
		return $income;
	}
}

/*
 * Checks the childcare frequency and converts it to an annual amount.
 *
 * @note It's 53 and not 52 for weekly because of the way the allowances
 * are rounded by HMRC.
 * @return int Annual childcare vouchers        
 */
function get_annual_childcare( $frequency, $amount ) 
{
	if ( WEEK === $frequency ) {
		return $amount * NUMBER_OF_WEEKS_ODD;
	} elseif ( MONTH === $frequency ) {
		return $amount * 12;
	}
}

/*
 * Trims the POST values created on submission of the tax form.
 *
 * @return string Trimmed POST value
 */
function get_sanitized_tax_option( $post ) {
	return trim( $_POST[ $post ] );
}
                            if ('POST' == $_SERVER['REQUEST_METHOD']) {

                                $persona = array(
                                    'year' => get_sanitized_tax_option('tax_year_is'),
                                    'income' => get_annual_income(get_sanitized_tax_option('income_every_x'), get_sanitized_tax_option('gross_income_is')),
                                    'other_allowance' => get_sanitized_tax_option('other_allowance_is'),
                                    'tax_code' => strtoupper(get_sanitized_tax_option('tax_code_is')),
                                    'age' => get_sanitized_tax_option('age_is'),
                                    'pension' => get_sanitized_tax_option('pension_contribution_is'),
                                    'pension_every' => get_sanitized_tax_option('pension_every_x'),
                                    'vouchers' => get_annual_childcare(get_sanitized_tax_option('vouchers_every_x'), get_sanitized_tax_option('childcare_vouchers_are')),
                                    'childcare_pre2011' => get_other_allowance('is_childcare_pre2011'),
                                    'blind' => get_other_allowance('is_blind'),
                                    'exclude_ni' => get_other_allowance('exclude_ni'),
                                    'student_loan' => get_other_allowance('has_student_loan'),
                                    'married' => get_other_allowance('is_married'),
                                );

                                $taxcalc = new Tax_Calculator($persona);

                                $taxcalc->calculate_taxes();

                            }

                            ?>

                            <?php //include 'assets_front/templates/header-template.php'; ?>

                                <?php //include 'assets_front/templates/calculator-template.php'; ?> </br></br>
                                <?php //include 'assets_front/templates/results-template.php'; ?>

<!--<link href='<?php echo base_url(); ?>assets_front/bootstrap/css/bootstrap.css' rel='stylesheet'>-->
<style>
.calculator_form {
	border: 1px solid #ddd;
}

.row {
	padding: 2px 0;
}

.calculator_form .row {
	border-bottom: 1px solid #ddd;
}

.radio-inline + .radio-inline, .checkbox-inline + .checkbox-inline {
	margin-top: 5px;
}

label, .last-col {
	margin: 5px 0;
}

span.glyphicon.glyphicon-chevron-right.open {
	-webkit-transform: rotate(90deg);
    -moz-transform: rotate(90deg);
    -o-transform: rotate(90deg);
    -ms-transform: rotate(90deg);
    transform: rotate(90deg);
}

.taxbands-row {
	background: #e74c3c;
	color: white;
	border-left: 1px solid #e74c3c;
	border-right: 1px solid #e74c3c;
}

#results .taxbands-row td {
	border: none;
}

#results .taxbands-row .odd {
	background: #c93224;
}

.tax-bands {
	background: #f97568;
	border-left: 1px solid #f97568;
	border-right: 1px solid #f97568;
}

.tax-bands .odd {
	background:#e55e52;
}

.net-row {
	background: #2ecc71;
	border-left: 1px solid #2ecc71;
	border-right: 1px solid #2ecc71;
}

.net-row .odd {
	background: #27ae60;
}

.net-row .row-label {
	font-weight: bold;
}

.pension-row {
	color: white;
	background: #3498db;
	border-left: 1px solid #2980b9;
	border-right: 1px solid #2980b9;
}

.pension-row .odd {
	background: #2980b9;
}

.hmrc-pension-row {
	background: #ccc;
	border-left: 1px solid #ccc;
	border-right: 1px solid #ccc;
}

.hmrc-pension-row .odd {
	background: #aeaeae;
}

.student-row {
	color: white;
	background: #34495e;
	border-left: 1px solid #34495e;
	border-right: 1px solid #34495e;
}

.student-row .odd {
	background: #2c3e50;
}

.childcare-row {
	color: white;
	background: #9b59b6;
	border-left: #9b59b6;
	border-right: #9b59b6;
}

.childcare-row .odd {
	background: #8e44ad;
}

#results .tax-bands td, #results .net-row td, #results .pension-row td,
#results .hmrc-pension-row td, #results .student-row td, #results .childcare-row td {
	border:none;
}

.yr, .mth, .wk, .day {
	text-align: right;
}

tr a .glyphicon {
	color: white;
}

tr a .glyphicon:hover {
	color: #ecf0f1;
}

@media (min-width: 1200px) {
	.container {
		width: 970px;
	}
}
</style>
<form method='post' action='<?php echo base_url();?>front_end/salary_calculator'>

    <style type="text/css">
        /*SALARY-CALCULATOR*/

        .calculator-form {
            margin-top: 15px;
            padding-left: 20px;
        }

        .calculator-form ul{
        padding: 0;

        }

        .calculator-form ul li {
            height: 90px;
        }

        .calculator-form ul li label {
            color: #333;
            font-size: 14px;
            font-weight: normal;
        }

        .calculator-form ul li input[type="text"]{
            font-size: 14px;
        }

        .calculator-form ul li select{
        font-size: 14px;
        }


        .calculator-form ul li input[type="submit"] {
            background: #ce0229 none repeat scroll 0 0;
            border: medium none;
            border-radius: 50px;
            color: #fff;
            padding: 10px 40px;
        }

        /*SALARY-CALCULATOR*/

    </style>



    <div class="calculator-form">

        <ul class="row">
            <li class="col-md-6">
                <label>Select tax year</label>
                <select id='tax_year_is' name='tax_year_is'>
                    <option value='year2014_15' name='year2014_15'
                            id='year2014_15' <?php if (isset($_POST['tax_year_is']) && 'year2014_15' == $_POST['tax_year_is']) {
                        echo 'selected';
                    } elseif (!isset($_POST['tax_year_is'])) {
                        echo 'selected';
                    } ?>>2015/16
                    </option>
                    <option value='year2014_15' name='year2014_15'
                            id='year2014_15' <?php if (isset($_POST['tax_year_is']) && 'year2014_15' == $_POST['tax_year_is']) {
                        echo 'selected';
                    } elseif (!isset($_POST['tax_year_is'])) {
                        echo 'selected';
                    } ?>>2014/15
                    </option>

                    <option value='year2013_14' name='year2013_14'
                            id='year2013_14' <?php if (isset($_POST['tax_year_is']) && 'year2013_14' == $_POST['tax_year_is']) {
                        echo 'selected';
                    } ?>>2013/14
                    </option>
                    <option value='year2012_13' name='year2012_13'
                            id='year2012_13' <?php if (isset($_POST['tax_year_is']) && 'year2012_13' == $_POST['tax_year_is']) {
                        echo 'selected';
                    } ?>>2012/13
                    </option>
                    <option value='year2011_12' name='year2011_12'
                            id='year2011_12' <?php if (isset($_POST['tax_year_is']) && 'year2011_12' == $_POST['tax_year_is']) {
                        echo 'selected';
                    } ?>>2011/12
                    </option>
                    <option value='year2010_11' name='year2010_11'
                            id='year2010_11' <?php if (isset($_POST['tax_year_is']) && 'year2010_11' == $_POST['tax_year_is']) {
                        echo 'selected';
                    } ?>>2010/11
                    </option>
                    <option value='year2009_10' name='year2009_10'
                            id='year2009_10' <?php if (isset($_POST['tax_year_is']) && 'year2009_10' == $_POST['tax_year_is']) {
                        echo 'selected';
                    } ?>>2009/10
                    </option>
                </select>
            </li>

            <li class="col-md-6">
                <label>Gross</label>
                <select id='income_every_x' name='income_every_x' style="margin-bottom: 15px;">
                    <option
                        value='year' <?php if (isset($_POST['income_every_x']) && 'year' == $_POST['income_every_x']) {
                        echo 'selected';
                    } ?>>Yearly
                    </option>
                    <option
                        value='month' <?php if (isset($_POST['income_every_x']) && 'month' == $_POST['income_every_x']) {
                        echo 'selected';
                    } ?>>Monthly
                    </option>
                    <option
                        value='week' <?php if (isset($_POST['income_every_x']) && 'week' == $_POST['income_every_x']) {
                        echo 'selected';
                    } ?>>Weekly
                    </option>
                    <option
                        value='day' <?php if (isset($_POST['income_every_x']) && 'day' == $_POST['income_every_x']) {
                        echo 'selected';
                    } ?>>Daily
                    </option>
                </select>
            </li>


            <li class="col-md-6">
                <label>Income</label>
                <input type='text' style='margin-bottom: 15px;' id='gross_income_is' name='gross_income_is'
                       class='form-control input-sm' value='<?php if (isset($_POST['gross_income_is'])) {
                    echo $_POST['gross_income_is'];
                } ?>'
            </li>

            <li class="col-md-6">
                <label>Other allowances</label>
                <input type='text' id='other_allowance_is' style="margin-bottom: 15px;"
                       class='form-control input-sm' name='other_allowance_is'
                       value='<?php if (isset($_POST['other_allowance_is'])) {
                           echo $_POST['other_allowance_is'];
                       } ?>'>
            </li>

            <li class="col-md-6">
                <label>Tax code (if known)</label>
                <input type='text' id='tax_code_is' style="margin-bottom: 15px;" class='form-control input-sm'
                       name='tax_code_is' value='<?php if (isset($_POST['tax_code_is'])) {
                    echo $_POST['tax_code_is'];
                } ?>'>
            </li>

            <li class="col-md-6">
                <label>Age</label>
                <select id='age_is' name='age_is' style="margin-bottom: 15px;">
                    <option value='under_65' <?php if (isset($_POST['age_is']) && 'under_65' == $_POST['age_is']) {
                        echo 'selected';
                    } ?>>Under 65
                    </option>
                    <option value='65_74' <?php if (isset($_POST['age_is']) && '65_74' == $_POST['age_is']) {
                        echo 'selected';
                    } ?>>65-74
                    </option>
                    <option value='over_75' <?php if (isset($_POST['age_is']) && 'over_75' == $_POST['age_is']) {
                        echo 'selected';
                    } ?>>Over 75
                    </option>
                </select>
            </li>

            <li class="col-md-6">
                <label>Pension contribution is</label>
                <select id='pension_every_x' name='pension_every_x' style="margin-bottom: 15px;">
                    <option
                        value='month' <?php if (isset($_POST['pension_every_x']) && 'month' == $_POST['pension_every_x']) {
                        echo 'selected';
                    } elseif (!isset($_POST['pension_every_x'])) {
                        echo 'selected';
                    } ?>>Monthly
                    </option>
                    <option
                        value='year' <?php if (isset($_POST['pension_every_x']) && 'year' == $_POST['pension_every_x']) {
                        echo 'selected';
                    } ?>>Yearly
                    </option>
                </select>
            </li>

            <li class="col-md-6">
                <label>&nbsp;</label>
                <input type='text' id='pension_contribution_is' style="margin-bottom: 15px;"
                       class='form-control input-sm' name='pension_contribution_is'
                       value='<?php if (isset($_POST['pension_contribution_is'])) {
                           echo $_POST['pension_contribution_is'];
                       } ?>'>
            </li>

            <li class="col-md-6">
                <label>Childcare vouchers</label>
                <input type='text' id='childcare_vouchers_are' style="margin-bottom: 15px;"
                       class='form-control input-sm' name='childcare_vouchers_are'
                       value='<?php if (isset($_POST['childcare_vouchers_are'])) {
                           echo $_POST['childcare_vouchers_are'];
                       } ?>'>
            </li>

            <li class="col-md-6">
                <label>&nbsp;</label>
                <select id='vouchers_every_x' name='vouchers_every_x' style="margin-bottom: 15px;">
                    <option
                        value='week' <?php if (isset($_POST['vouchers_every_x']) && 'week' == $_POST['vouchers_every_x']) {
                        echo 'selected';
                    } ?>>Week
                    </option>
                    <option
                        value='month' <?php if (isset($_POST['vouchers_every_x']) && 'month' == $_POST['vouchers_every_x']) {
                        echo 'selected';
                    } elseif (!isset($_POST['vouchers_every_x'])) {
                        echo 'selected';
                    } ?>>Month
                    </option>
                </select>
            </li>

            <li class="col-md-12" style="height: auto; margin-bottom: 15px;">
                <label for='is_blind' class='checkbox-inline'>
                    <input type='checkbox' style="margin-top: 3px;" id='is_blind' name='is_blind'
                        <?php if (isset($_POST['is_blind']) && 'on' == $_POST['is_blind']) {
                            echo 'checked';
                        } ?> >I am blind
                </label>

                <label for='exclude_ni' class='checkbox-inline'>
                    <input type='checkbox' style="margin-top: 3px;" id='exclude_ni' name='exclude_ni'
                        <?php if (isset($_POST['exclude_ni']) && 'on' == $_POST['exclude_ni']) {
                            echo 'checked';
                        } ?> >I do not pay NI
                </label>

                <label for='is_married' class='checkbox-inline'>
                    <input type='checkbox' style="margin-top: 3px;" id='is_married' name='is_married'
                        <?php if (isset($_POST['is_married']) && 'on' == $_POST['is_married']) {
                            echo 'checked';
                        } ?> >Married
                </label>
                <label for='has_student_loan' class='checkbox-inline'>
                    <input type='checkbox' style="margin-top: 3px;" id='has_student_loan'
                           name='has_student_loan'
                        <?php if (isset($_POST['has_student_loan']) && 'on' == $_POST['has_student_loan']) {
                            echo 'checked';
                        } ?> >I have a student loan
                </label>

            </li>
            <li class="col-md-12" style="height: auto;"><input type='submit' id='calculate_taxes' name='calculate_taxes' value='Calculate'/></li>
        </ul>
    </div>

</form> </br></br>
<style type="text/css">

	.table-responsive{
		border: 1px solid #dadada;
		border-radius: 20px;
		margin-left: 20px;
	}

	.table-responsive table{
		border: none !important;
	}

	.table-responsive tr{
		border: none !important;
		border-bottom:1px solid #DADADA !important;
	}

	.table-responsive td{
		border: none !important;
		padding: 8px !important;
		border-right:1px solid #DADADA !important;
		font-size: 14px;
	}

	.table-responsive th{
		border: none !important;
		padding: 8px !important;
		border-right:1px solid #DADADA !important;
	}

	.table-responsive th:last-child{
		border: none !important;
	}

	.table-responsive td:last-child{
		border: none !important;
	}


</style>
<div class='table-responsive'>
		<table id='results' class='table table-bordered table-condensed'>

			<tr style='text-transform:none;' class='results-header'>
				<th class='row-label'><div align="center">Salary Summary</div></th>
				<th class='yr'><div align="center">Yearly</div></th>
				<th class='mth'><div align="center">Monthly</div></th>
				<th class='wk'><div align="center">Weekly</div></th>
				<th class='day col-day'><div align="center">Daily</div></th>
			</tr>

			<tr class='gross-row'>
				<td class='row-label'><div align="center">Gross Income</div></td>
				<td class='yr'>
				  <div align="center">
				    <?php 
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_gross_income, 2 ); 
						} else { 
							echo '&pound;' . number_format( 0, 2 );
						} 
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php 
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_gross_income / 12, 2 ); 
						} else {
							echo '&pound;' . number_format( 0, 2 );
						} 
				?>				
		        </div></td>
				<td class='wk'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_gross_income / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_gross_income / 260, 2 ); 
						} else {
							echo '&pound;' . number_format( 0, 2 );
							}
				?>				
		        </div></td>
			</tr>

			<tr class='childcare-row' <?php if ( !isset( $taxcalc->show_childcare_vouchers ) || $taxcalc->show_childcare_vouchers == 0 ) { echo 'style="display:none"'; } ?>>
				<td class='row-label'><div align="center">Childcare Vouchers</div></td>
				<td class='yr odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_childcare_vouchers, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( round( $taxcalc->show_childcare_vouchers / 12 ), 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( round( $taxcalc->show_childcare_vouchers / 53 ), 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( round( $taxcalc->show_childcare_vouchers / 260 ), 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='tfa-row'>
				<td class='row-label'><div align="center">Tax free Allowance</div></td>
				<td class='yr'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_tax_free_allowance, 2 );
						} else {
							echo '&pound;' . number_format( 10000, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_tax_free_allowance / 12, 2 );
						} else {
							echo '&pound;' . number_format( 10000 / 12, 2 );
						}
				?>				
		        </div></td>
				<td class='wk'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_tax_free_allowance / 52, 2 );
						} else {
							echo '&pound;' . number_format( 10000 / 52, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_tax_free_allowance / 260, 2 );
						} else {
							echo '&pound;' . number_format( 10000 / 260, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='taxable-row'>
				<td class='row-label'><div align="center">Total taxable</div></td>
				<td class='yr'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->total_taxable_amount, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->total_taxable_amount / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->total_taxable_amount / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->total_taxable_amount / 260, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='taxbands-row' style="background: #ce0229;color: white;border-left: 1px solid #ce0229;border-right: 1px solid #ce0229;">
				<td class='row-label'><div align="center"><a id='tax-expand' href='javascript:'><span class='glyphicon glyphicon-chevron-right'></span></a>&nbsp;Tax Due</div></td>
				<td class='yr odd' style="background: #ce0229;color: white;border-left: 1px solid #ce0229;border-right: 1px solid #ce0229;">
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->total_tax_due, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth' style="background: #ce0229;color: white;border-left: 1px solid #ce0229;border-right: 1px solid #ce0229;">
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->total_tax_due / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk odd' style="background: #ce0229;color: white;border-left: 1px solid #ce0229;border-right: 1px solid #ce0229;">
				  <div align="center">
				    <?php 
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->total_tax_due / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->total_tax_due / 260, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );

						}
				?>
		        </div></td>
			</tr>

			<tr  id='taxband1-row' class='tax-bands' style='display:none'>
				<td class='row-label'>&nbsp;&nbsp;&nbsp;
				  <div align="center"><em>
			      <?php
					if ( isset( $taxcalc ) ) {
							echo $taxcalc->bands['additional']['rate'];
						} else { 
							echo 45;
						}
				?>
		        % tax rate</em>		          </div></td>
				<td class='yr odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['additional'], 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['additional'] / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['additional'] / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['additional'] / 260, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr id='taxband2-row' class='tax-bands' style='display:none'>
				<td class='row-label'>&nbsp;&nbsp;&nbsp;&nbsp;
			    <div align="center"><em>40% tax rate</em></div></td>
				<td class='yr odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['higher'], 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['higher'] / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['higher'] / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['higher'] / 260, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr id='taxband3-row' class='tax-bands' style='display:none'>
				<td class='row-label'>&nbsp;&nbsp;&nbsp;&nbsp;
			    <div align="center"><em>20% tax rate</em></div></td>
				<td class='yr odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['basic'], 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['basic'] / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['basic'] / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc->deduction ) ) {
							echo '&pound;' . number_format( $taxcalc->deduction['basic'] / 260,2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='student-row' <?php if ( !isset( $taxcalc->show_student_loan_amount ) ) { echo 'style="display:none"'; } ?>>
				<td class='row-label'><div align="center">Student Loan</div></td>
				<td class='yr odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) && isset( $taxcalc->show_student_loan_amount ) ) {
							echo '&pound;' . number_format( $taxcalc->show_student_loan_amount, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) && isset( $taxcalc->show_student_loan_amount ) ) {
							echo '&pound;' . number_format( floor( $taxcalc->show_student_loan_amount / 12 ), 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) && isset( $taxcalc->show_student_loan_amount ) ) {
							echo '&pound;' . number_format( floor( $taxcalc->show_student_loan_amount / 52 ), 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) && isset( $taxcalc->show_student_loan_amount ) ) {
							echo '&pound;' . number_format( floor( $taxcalc->show_student_loan_amount / 260), 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='ni-row'>
				<td class='row-label'><div align="center">National Insurance</div></td>
				<td class='yr'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_ni_contribution, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_ni_contribution / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_ni_contribution / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_ni_contribution / 260, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='pension-row' <?php if ( !isset( $taxcalc->show_employer_pension ) || $taxcalc->show_employer_pension == 0 ) { echo 'style="display:none"'; } ?>>
				<td class='row-label'><div align="center"><a id='pension-expand' href='javascript:'><span class='glyphicon glyphicon-chevron-right'></span></a>&nbsp;Pension [You]</div></td>
				<td class='yr odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_employer_pension, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_employer_pension / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_employer_pension / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_employer_pension / 260, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='hmrc-pension-row' style='display:none'>
				<td class='row-label'><div align="center">Pension [HMRC]</div></td>
				<td class='yr odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_pension_hmrc, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_pension_hmrc / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='wk odd'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_pension_hmrc / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_pension_hmrc / 260, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='total-deductions-row'>
				<td class='row-label'><div align="center">Total Deductions</div></td>
				<td class='yr'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_total_deduction, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>
		        </div></td>
				<td class='mth'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_total_deduction / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>
		        </div></td>
				<td class='wk'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_total_deduction / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
				<td class='day'>
				  <div align="center">
				    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_total_deduction / 260,2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>				
		        </div></td>
			</tr>

			<tr class='net-row' style="background: #ce0229;color: white;border-left: 1px solid #ce0229;border-right: 1px solid #ce0229;">
				<td class='row-label'><div align="center">Net Income</div></td>
				<td class='yr odd' style="background: #ce0229;color: white;border-left: 1px solid #ce0229;border-right: 1px solid #ce0229;"><div align="center">
			    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_net_income, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>
			    </div></td>
				<td class='mth' style="background: #ce0229;color: white;border-left: 1px solid #ce0229;border-right: 1px solid #ce0229;"><div align="center">
			    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_net_income / 12, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>
			    </div></td>
				<td class='wk odd' style="background: #ce0229;color: white;border-left: 1px solid #ce0229;border-right: 1px solid #ce0229;"><div align="center">
			    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_net_income / 52, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>
			    </div></td>
				<td class='day'><div align="center">
			    <?php
					if ( isset( $taxcalc ) ) {
							echo '&pound;' . number_format( $taxcalc->show_net_income / 260, 2 );
						} else {
							echo '&pound;' . number_format( 0, 2 );
						}
				?>
			    </div></td>
			</tr>	
		</table>
</div>                          
<!--
<script src='<?php echo base_url(); ?>assets_front/js/jquery-1.8.3.min.js'></script>-->
<script src='<?php echo base_url(); ?>assets_front/js/app.js'></script>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--CONTENT-AREA-->
<?php $this->load->view('footer_front'); ?>