var atinternet = {
  config: {
    signup: {
      xtn2: '9',
      xtc_type: 'F',
      xtc_name: 'Registration'
    },
    signup_success: {
      xtn2: '9',
      xtc_type: 'F',
      xtc_name: 'Registration_Successful'
    },
    signup_error: {
      xtn2: '9',
      xtc_type: 'F',
      xtc_name: 'Registration_Error'
    },
    login: {
      xtn2: '7',
      xtc_type: 'F',
      xtc_name: 'Login'
    },
    findjobs_top: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Back_to_top'
    },
    findjobs_remove_keyword: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Filter::Remove_Keyword'
    },
    findjobs_search_keyword: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Filter::Search_Keyword::%s'
    },
    findjobs_search_keyword_mobile: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Mobile_Filter::Search_Keyword::%s'
    },
    findjobs_search_location: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Filter::Location::%s'
    },
    findjobs_search_location_mobile: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Mobile_Filter::Location::%s'
    },
    findjobs_search_jobtype: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Filter::Job_Types'
    },
    findjobs_search_jobtype_mobile: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Mobile_Filter::Job_Types'
    },
    findjobs_search_jobfunc: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Filter::Job_Functions::%s'
    },
    findjobs_search_jobfunc_mobile: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Mobile_Filter::Job_Functions'
    },
    findjobs_search_section_category: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Filter::%s'
    },
    findjobs_search_language_section_mobile: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Mobile_Filter::Language::%s'
    },
    jobdetail_share: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Ad_Detail::Share::%s'
    },
    jobdetail_apply: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Apply::%s'
    },
    jobdetail_applied: {
      xtn2: '2',
      xtc_type: 'F',
      xtc_name: 'Find_Jobs::Applied::%s'
    },
    jobdetail_apply_via_app: {
      xtn2: '2',
      xtc_type: 'F',
      xtc_name: 'Find_Jobs::Apply_via_App'
    },
    jobdetail_save: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Save_Job'
    },
    jobdetail_unsave: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Unsave_Job'
    },
    jobdetail_view_email: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Ad_Detail::View_Email::%s'
    },
    jobdetail_view_phone: {
      xtn2: '2',
      xtc_type: 'A',
      xtc_name: 'Find_Jobs::Ad_Detail::View_Phone::%s'
    },
    build_profile: {
      xtn2: '8',
      xtc_type: 'F',
      xtc_name: 'Build_Profile'
    },
    build_empstatus: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Build_Empsts'
    },
    build_workexp: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Build_Workexp'
    },
    build_education: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Build_Education'
    },
    profile_add_workexp: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Add_Work_Experience'
    },
    profile_add_workexp_success: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Added_Work_Experience'
    },
    profile_remove_workexp_success: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Removed_Work_Experience'
    },
    profile_add_educ: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Add_Education'
    },
    profile_add_educ_success: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Added_Education'
    },
    profile_remove_educ_success: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Removed_Education'
    },
    profile_update_language: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Update_Language'
    },
    profile_update_language_success: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Updated_Language'
    },
    profile_update_skills_success: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Updated_Skills'
    },
    profile_upload_resume: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Upload_Resume'
    },
    profile_generate_resume: {
      xtn2: '8',
      xtc_type: 'A',
      xtc_name: 'Profile::Generate_Resume'
    }
  },
  
  tagActionClick: function(name, dynamicLabel) {
    if ( ! name || typeof this.config[name] === 'undefined') {
      return;
    }

    this.trackClickEvent(this.config[name], dynamicLabel);
  },

  trackClickEvent: function(params, dynamicLabel) {
    if ( ! params.xtc_name ) {
      return;
    }

    if ( ! params.xtn2 ) {
      params.xtn2 = 5;
    }

    if ( ! params.xtc_type ) {
      params.xtc_type = 'A';
    }

    params.xtc_name = params.xtc_name.replace(/[&@\*$!\[\]]/g, '');
    
    var xtc_name = params.xtc_name;
    if ( typeof dynamicLabel !== 'undefined' ) {
      xtc_name = xtc_name.replace('%s', dynamicLabel);
    }

    if ( params.xtc_type === 'F' ) {
      xt_click(this,'F', params.xtn2, xtc_name);
    } else {
      xt_click(this, 'C', params.xtn2, xtc_name, params.xtc_type);
    }
  }
};

var ganalytics = {
  tagActionClick: function(name, dynamicLabel, dynamicUrl) {
    if ( ! name || typeof fastjobsTagging.config[name] === 'undefined') {
      return;
    }

    var params = fastjobsTagging.config[name];
    if ( typeof params.type === 'virtual_page' ) {
      var pageUrl = ( typeof dynamicUrl !== 'undefined' ) ? dynamicUrl : params.url;
      this.trackVirtualPage(params.name, pageUrl);
    } else {
      this.trackEvent(params, dynamicLabel);
    }

    if ( typeof fastjobsTagging.goalConfig[name] !== 'undefined' ) {
      var goalParams = fastjobsTagging.goalConfig[name];
      this.trackEvent(goalParams, dynamicLabel);
    }
  },

  trackEvent: function(params, dynamicLabel) {
    if ( ! params.category || ! params.action ) {
      return;
    }

    if ( ! params.label ) params.label = '';

    params.action = params.action.replace(/[&@\*$!\[\]]/g, '');

    var eventLabel = params.label;
    if ( typeof dynamicLabel !== 'undefined' ) {
      eventLabel = eventLabel.replace('%s', dynamicLabel);
    }

    ga('send', 'event', params.category, params.action, eventLabel );
  },

  trackPage: function() {
    ga('send', 'pageview');
  },

  trackVirtualPage: function(title, page) {
    if ( ! title || ! page ) {
      return;
    }

    ga('send', {'hitType': 'pageview', 'title': title, 'page': page});
  }
};

var gtagmanager = {
  tagActionClick: function(name, dynamicLabel) {
    if ( ! name || typeof fastjobsTagging.config[name] === 'undefined') {
      return;
    }

    var params = fastjobsTagging.config[name];
    if ( params.type === 'event' ) {
      this.trackEvent(params, dynamicLabel);
    }

    if ( typeof fastjobsTagging.goalConfig[name] !== 'undefined' ) {
      var goalParams = fastjobsTagging.goalConfig[name];
      this.trackEvent(goalParams, dynamicLabel);
    }
  },

  trackEvent: function(params, dynamicLabel) {
    if ( typeof dataLayer === 'undefined' || ! params.category || ! params.action ) {
      return;
    }

    if ( ! params.label ) params.label = '';

    params.action = params.action.replace(/[&@\*$!\[\]]/g, '');

    var eventLabel = params.label;
    if ( typeof dynamicLabel !== 'undefined' ) {
      eventLabel = eventLabel.replace('%s', dynamicLabel);
    }
    
    dataLayer.push({
      "event": "custom_event",
      "eventCategory": params.category,
      "eventAction": params.action,
      "eventLabel": eventLabel
    });
  }
};

var fastjobsTagging = {
  config: {
    signup: {
      type: 'virtual_page',
      name: 'Registration',
      url: '/jobseeker/signup'
    },
    signup_success: {
      type: 'virtual_page',
      name: 'Registration Successful',
      url: '/jobseeker/signup-success'
    },
    signup_error: {
      type: 'virtual_page',
      name: 'Registration Error',
      url: '/jobseeker/signup'
    },
    login: {
      type: 'virtual_page',
      name: 'Jobseeker Login',
      url: '/jobseeker/login'
    },
    findjobs_top: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Back_to_Top',
      label: 'Back to top'
    },
    findjobs_remove_keyword: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Filter',
      label: 'Remove Keyword'
    },
    findjobs_search_keyword: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Filter',
      label: 'Keyword - %s'
    },
    findjobs_search_keyword_mobile: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Mobile_Filter',
      label: 'Keyword - %s'
    },
    findjobs_search_location: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Filter',
      label: 'Location - %s'
    },
    findjobs_search_location_mobile: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Mobile_Filter',
      label: 'Location - %s'
    },
    findjobs_search_jobtype: {
      type: 'event',
      category: 'Filter',
      action: 'Filter',
      label: 'Job Type'
    },
    findjobs_search_jobtype_mobile: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Mobile_Filter',
      label: 'Job Type'
    },
    findjobs_search_jobfunc: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Filter',
      label: 'Job Function - %s'
    },
    findjobs_search_jobfunc_mobile: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Mobile_Filter',
      label: 'Job Function'
    },
    findjobs_search_section_category: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Filter',
      label: 'Language_Category'
    },
    findjobs_search_language_section_mobile: {
      type: 'event',
      category: 'Find_Jobs',
      action: 'Mobile_Filter',
      label: 'Language_Section - %s'
    },
    jobdetail_share: {
      type: 'event',
      category: 'Ad_Detail',
      action: 'Share',
      label: '%s'
    },
    jobdetail_apply: {
      type: 'event',
      category: 'Ad_Detail',
      action: 'Apply',
      label: '%s'
    },
    jobdetail_applied: {
      type: 'virtual_page',
      name: 'Applied via %s',
      url: ''
    },
    jobdetail_apply_via_app: {
      type: 'virtual_page',
      name: 'Applied via App',
      url: ''
    },
    jobdetail_save: {
      type: 'event',
      category: 'Ad_Detail',
      action: 'Save',
      label: 'Save'
    },
    jobdetail_unsave: {
      type: 'event',
      category: 'Ad_Detail',
      action: 'Unsave',
      label: 'Unsave'
    },
    jobdetail_view_email: {
      type: 'event',
      category: 'Ad_Detail',
      action: 'View_Email',
      label: '%s'
    },
    jobdetail_view_phone: {
      type: 'event',
      category: 'Ad_Detail',
      action: 'View_Phone',
      label: '%s'
    },
    build_profile: {
      type: 'virtual_page',
      name: 'Build Profile',
      url: '/profile/showstrengthenprofile'
    },
    build_empstatus: {
      type: 'event',
      category: 'Profile',
      action: 'Build_Profile',
      label: 'Employment Status'
    },
    build_workexp: {
      type: 'event',
      category: 'Profile',
      action: 'Build_Profile',
      label: 'Work Experience'
    },
    build_education: {
      type: 'event',
      category: 'Profile',
      action: 'Build_Profile',
      label: 'Education'
    },
    profile_add_workexp: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Add Work Experience'
    },
    profile_add_workexp_success: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Added Work Experience'
    },
    profile_remove_workexp_success: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Removed Work Experience'
    },
    profile_add_educ: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Add Education'
    },
    profile_add_educ_success: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Added Education'
    },
    profile_remove_educ_success: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Removed Education'
    },
    profile_update_language: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Update Language'
    },
    profile_update_language_success: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Updated Language'
    },
    profile_update_skills_success: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Updated Skills'
    },
    profile_upload_resume: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Upload Resume'
    },
    profile_generate_resume: {
      type: 'event',
      category: 'Profile',
      action: 'Edit_Profile',
      label: 'Generate Resume'
    },
    employer_download_app: {
      type: 'event',
      category: 'EmployerApp',
      action: 'Download',
      label: 'Send to SMS'
    },
    employer_download_app_link_sent: {
      type: 'event',
      category: 'EmployerApp',
      action: 'Dwonload_Link_Sent',
      label: 'SMS Sent'
    },
    employer_request_account_success: {
      type: 'event',
      category: 'Employer_Enquiry',
      action: 'RequestAccount',
      label: 'Request Account Success'
    },
    employer_request_account_failed: {
      type: 'event',
      category: 'Employer_Enquiry',
      action: 'RequestAccount',
      label: 'Request Account Failed'
    }
  },
  
  goalConfig: {
    jobdetail_apply: {
      type: 'event',
      category: 'Apply for Job',
      action: 'Click',
      label: 'Apply for Job'
    }
  },
  
  tagEvent: function(params) {
    if ( ! params || typeof params.name === 'undefined' ) {
      return;
    }

    var name = params.name;
    var label = ( typeof params.label !== 'undefined' ) ? params.label : '';
    var url = ( typeof params.url !== 'undefined' && ! $.trim(params.url).isEmpty() ) ? params.url : '';

    atinternet.tagActionClick(name, label);
    /*ganalytics.tagActionClick(name, label, url);*/
    gtagmanager.tagActionClick(name, label);
  }
};
